package org.msh.test.variables;

import org.junit.Test;
import org.msh.tb.reports2.variables.concat.ConcatVariableInfo;
import org.msh.tb.reports2.variables.concat.ConcatVariableParser;
import org.msh.tb.reports2.variables.concat.ParsedData;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

import static org.junit.Assert.*;

/**
 * Created by rmemoria on 15/12/16.
 */
public class ConcatVariableParserTest {

//    @Test
    public void parseVars() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String varId = "var1,var2";
        List<String> vars = splitVars(varId);

        assertNotNull(vars);
        assertEquals(2, vars.size());
        assertEquals("var1", vars.get(0));
        assertEquals("var2", vars.get(1));

        vars = splitVars("var1");
        assertNotNull(vars);
        assertEquals(1, vars.size());
        assertEquals("var1", vars.get(0));

        varId = "var1,var2 total=0 regexp='10,20' error='blabla";
        vars = splitVars(varId);
        assertNotNull(vars);
        assertEquals(2, vars.size());
        assertEquals("var1", vars.get(0));
        assertEquals("var2 total=0 regexp='10,20' error='blabla", vars.get(1));
    }

//    @Test
    public void testVariableParse() {
        String s = "var1";
        ConcatVariableInfo info = parseVariableInfo(s);

        assertNotNull(info);
        assertEquals("var1", info.getVariable());
        assertFalse(info.isCalcTotal());

        info = parseVariableInfo("var1 total regdate='2016;10' is=PULMONARY");
        assertNotNull(info);
        assertEquals("var1", info.getVariable());
        assertTrue(info.isCalcTotal());
        assertNotNull(info.getFilters());
        assertEquals(2, info.getFilters().size());
        assertTrue(info.getFilters().containsKey("regdate"));
        assertTrue(info.getFilters().containsKey("is"));
        assertEquals("PULMONARY", info.getFilters().get("is"));
        assertEquals("2016;10", info.getFilters().get("regdate"));
    }

//    @Test
    public void testParse() {
        ParsedData data = ConcatVariableParser.parse("var1,var2");
        List<ConcatVariableInfo> vars = data.getVariables();
        assertNotNull(vars);
        assertEquals(2, vars.size());
        assertEquals("var1", vars.get(0).getVariable());
        assertEquals("var2", vars.get(1).getVariable());
    }


    private List<String> splitVars(String s) {
        Class[] argTypes = { String.class };
        Object[] args = { s };

        return (List<String>)invokePrivateMethod("splitVars",
                argTypes, args);
    }


    private ConcatVariableInfo parseVariableInfo(String s) {
        Class[] argTypes = { String.class };
        Object[] args = { s };

        return (ConcatVariableInfo) invokePrivateMethod("parseVariableInfo",
                argTypes, args);
    }

    private Object invokePrivateMethod(String metName, Class[] argTypes, Object[] args) {
        try {
            // get method by reflection
            Method met = ConcatVariableParser.class.getDeclaredMethod(metName, argTypes);
            met.setAccessible(true);

            return met.invoke(null, args);

        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
